/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.google.inject.Singleton;

@Singleton
public class DebugWindow
implements Disposable {
    private static final float LINE_HEIGHT = 20.0f;
    private final Viewport viewport;
    private final Label label;
    private Stage stage;
    private Array<String> lines = new Array();
    public Vector2 offsetPosition = new Vector2();

    public DebugWindow() {
        this.viewport = new ScreenViewport();
        this.stage = new Stage(this.viewport);
        Skin uiSkin = new Skin(new FileHandle("assets/ui-skins/libgdx-default/uiskin.json"));
        this.label = new Label((CharSequence)"Default text", uiSkin);
        this.label.setPosition(20.0f, (float)Gdx.graphics.getHeight() - 30.0f);
        this.stage.addActor(this.label);
    }

    public void clearText() {
        this.lines.clear();
    }

    public void printLine(String line) {
        this.lines.add(line);
    }

    public void render() {
        StringBuilder linesBuilder = new StringBuilder();
        for (String line : this.lines) {
            linesBuilder.append(line).append("\n");
        }
        this.label.setText(linesBuilder.toString());
        Vector2 basePosition = new Vector2(20.0f, (float)Gdx.graphics.getHeight() - 20.0f - (float)this.lines.size * 20.0f);
        basePosition.add(this.offsetPosition);
        this.label.setPosition(basePosition.x, basePosition.y);
        this.stage.act(Gdx.graphics.getDeltaTime());
        this.stage.draw();
    }

    public void onResize(int screenWidth, int screenHeight) {
        this.viewport.update(screenWidth, screenHeight, true);
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }
}

